;**********************************************
; Test write  Data to PCF8574AP
; Hardware  : CP-PIC V4
; OSC	    : 10 MHZ [ HS mode ]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 01/8/2002
;**********************************************

     LIST P=16f877
     include <p16f877.inc>

#define   SDA     PORTC,4  
#define   SCL     PORTC,3

DT1       EQU       0x20
DT2       EQU       0x21
WR_BUF    EQU       0x23
COUNT     EQU       0x24
DAT       EQU       0x26
       
;*********************************************
          ORG       0x0000
          
	  BSF	    STATUS,RP0     ; select bank 1
          BCF       TRISC,4
          BCF       TRISC,3         
	  BCF	    STATUS,RP0     ; select bank 0

LOOP      MOVLW     0X55
	  MOVWF     DAT
	  CALL      SEND
          CALL      SDEL           ; delay
	  MOVLW     0XAA
	  MOVWF     DAT
	  CALL      SEND
	  CALL      SDEL
          GOTO	    LOOP

;********* SEND DATA TO PCF8574A **********
    
SEND      CALL	    START
          MOVLW     0x70           ; control byte PCF8574A      
          CALL      WR_I2C
          MOVF      DAT,W  	   ; out data to PCF8574A           
          CALL	    WR_I2C
	  CALL      STOP
          RETURN
	  
;****************** WRITE DATA TO I2C BUS ************************

WR_I2C		MOVWF	WR_BUF	      ; data to buffer
		MOVLW	.8            ; loop counter = 8
		MOVWF	COUNT
		CALL	SCL_LOW
		CALL    DELAY
WR_LOOP	        RLF	WR_BUF,F      ; rotate data to buffer
		BC	SEND_1        ; Branch to SEND_1 if carry = 1
SEND_0		CALL    SDA_LOW
		CALL	PULSE
		GOTO	CHECK
SEND_1		CALL	SDA_HIGH
		CALL	PULSE
CHECK		DECFSZ	COUNT,F
		GOTO	WR_LOOP
		CALL	SDA_HIGH
		CALL	RD_ACK
		RETURN 

;********  READ ACK **************
RD_ACK  	CALL	SDA_HIGH
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA            ; test bit SDA skip if = "0"
		GOTO	STOP           ; stop 
		BTFSS	SCL            ; test bit SCL skip if = "1"
		GOTO	$-1
	        CALL	SCL_LOW          
		CALL    DELAY
		RETURN

;******************************
; Start bit
;******************************
START		CALL	SDA_HIGH
		CALL	SCL_HIGH
		BTFSS	SCL
		GOTO	$-1
		BTFSS	SDA
		GOTO	$-1
		CALL	SDA_LOW
		CALL	SCL_LOW
		RETURN

;********  STOP *************
STOP		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SDA_HIGH
		CALL	DELAY
		RETURN

;******** SCL PULSE *************** 
PULSE    	CALL	SCL_LOW
	        CALL    DELAY
		CALL	SCL_HIGH
	        CALL    DELAY
		CALL	SCL_LOW
		RETURN

;********** SCL HIGH ********************
SCL_HIGH
        	BANKSEL TRISC
		BSF	TRISC,3
		BANKSEL	PORTC
		RETURN

;******** SCL LOW **********************
SCL_LOW
		BANKSEL	TRISC
		BCF	TRISC,3
		BANKSEL	PORTC
		BCF	SCL
		RETURN

;******** SDA HIGH ********************
SDA_HIGH	
		BANKSEL	TRISC
		BSF	TRISC,4
		BANKSEL	PORTC
		RETURN

;********  SDA  LOW *****************
SDA_LOW		
		BANKSEL	TRISC
		BCF	TRISC,4
		BANKSEL	PORTC
		BCF	SDA
		RETURN
;******************************
; DELAY TIME
;******************************
DELAY     MOVLW	    .5
	  MOVWF	    DT1
	  DECFSZ    DT1,F
	  GOTO	    $-1
	  RETURN

SDEL      MOVLW     0x00
          MOVWF     DT1
SD2       MOVLW     0x00
          MOVWF     DT2
SD1       DECFSZ    DT2
          GOTO      SD1
          DECFSZ    DT1
          GOTO      SD2
          RETURN
	
	END
